/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin;

import com.scutech.dbackup.vsphere.plugin.services.HTTPServiceImpl;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DataProviderImpl
implements PropertyProviderAdapter {
    private VimObjectReferenceService _vimObjectReferenceService = null;
    private DataService _dataService = null;
    private UserSessionService _userSessionService = null;
    private static final String VM_TYPE = "VirtualMachine";
    private static final String VM_UUID = "summary.config.uuid";
    private static final String DACKUP_PROPERTY = "dBackuptask";
    private final HTTPServiceImpl _HTTPService = new HTTPServiceImpl();
    private static final String[] VM_TASK_STATUS_ARR_CN = new String[]{"\u65e0\u4f5c\u4e1a", "\u65b0\u5efa\u5b8c\u6210", "\u8fd0\u884c\u4e2d", "\u505c\u6b62", "\u5b8c\u6210", "\u6682\u505c", "\u51fa\u9519", "\u7f51\u7edc\u9519\u8bef", "\u505c\u6b62\u4e2d", "\u4fee\u6539\u4e2d", "\u521d\u59cb\u5316"};
    private static final String[] VM_TASK_STATUS_ARR_US = new String[]{"No task", "Created", "Running", "Stopped", "Finished", "Paused", "Error", "Network error", "Stopping", "Modifying", "Initializing"};

    public DataProviderImpl(DataServiceExtensionRegistry extensionRegistry, VimObjectReferenceService vimObjectReferenceService, DataService dataService, UserSessionService userSessionService) {
        this._vimObjectReferenceService = vimObjectReferenceService;
        this._dataService = dataService;
        this._userSessionService = userSessionService;
        TypeInfo vmTypeInfo = new TypeInfo();
        vmTypeInfo.type = VM_TYPE;
        vmTypeInfo.properties = new String[]{DACKUP_PROPERTY};
        TypeInfo[] providerTypes = new TypeInfo[]{vmTypeInfo};
        extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, providerTypes);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ResultSet result = new ResultSet();
        try {
            ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
            int onum = 0;
            String[] vmStatusArr = this.getVmProperties(propertyRequest.objects);
            for (Object objectRef : propertyRequest.objects) {
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = objectRef;
                resultItem.properties = new PropertyValue[1];
                PropertyValue vmProp = new PropertyValue();
                vmProp.resourceObject = objectRef;
                vmProp.propertyName = DACKUP_PROPERTY;
                vmProp.value = this.GetStatusString(vmStatusArr, onum, propertyRequest.objects.length);
                resultItem.properties[0] = vmProp;
                if (resultItem != null) {
                    resultItems.add(resultItem);
                }
                ++onum;
            }
            result.items = resultItems.toArray(new ResultItem[0]);
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    private String GetStatusString(String[] vmStatusArr, int num, int objNum) {
        String status = "--";
        if (vmStatusArr.length == objNum && num < vmStatusArr.length) {
            try {
                int statusNum = Integer.parseInt(vmStatusArr[num]);
                if (0 <= statusNum && statusNum <= 10) {
                    status = this._userSessionService.getUserSession().locale.equals("zh_CN") ? VM_TASK_STATUS_ARR_CN[statusNum] : VM_TASK_STATUS_ARR_US[statusNum];
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return status;
    }

    private String getServerInfoIP(String serverGuid) {
        String ip = "";
        UserSession userSession = this._userSessionService.getUserSession();
        for (ServerInfo sinfo : userSession.serversInfo) {
            if (!sinfo.serviceGuid.equalsIgnoreCase(serverGuid)) continue;
            ip = sinfo.name;
        }
        return ip;
    }

    private String[] getVmProperties(Object[] vmRefs) throws Exception {
        ArrayList<String> vmUUIDArr = this.getVmUUIDs(vmRefs);
        String[] TaskStatusArr = this.getVmDbackupTaskStatusArr(vmUUIDArr);
        return TaskStatusArr;
    }

    private ArrayList<String> getVmUUIDs(Object[] vmRefs) throws Exception {
        String[] properties = new String[]{VM_UUID};
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < vmRefs.length; ++i) {
            String uuid = "";
            QuerySpec query = this.buildQuerySpec(vmRefs[i], properties);
            ResultSet UUIDSets = this.getData(this._dataService, query);
            if (UUIDSets != null && UUIDSets.items != null) {
                for (ResultItem item : UUIDSets.items) {
                    if (item == null || item.properties == null) continue;
                    for (PropertyValue propValue : item.properties) {
                        if (propValue.propertyName != VM_UUID) continue;
                        uuid = propValue.value.toString();
                    }
                }
            }
            result.add(uuid);
        }
        return result;
    }

    private String[] getVmDbackupTaskStatusArr(ArrayList<String> vmUUIDArr) throws Exception {
        String param = "";
        param = "uuids=" + this.GetArrString(vmUUIDArr);
        String pathUrl = "/ds/dbackup/vcenter/vm/task";
        this._HTTPService.isReady();
        String result = this._HTTPService.sendPost(pathUrl, param);
        return this.StringToArr(result);
    }

    private String GetArrString(ArrayList<String> vmUUIDArr) {
        String arrString = "";
        int length = vmUUIDArr.size();
        for (int i = 0; i < length; ++i) {
            arrString = arrString + vmUUIDArr.get(i);
            if (i == length - 1) continue;
            arrString = arrString + ",";
        }
        return arrString;
    }

    private String[] StringToArr(String str) {
        String[] statusArr = str.split(",");
        return statusArr;
    }

    private PropertySpec createPropertySpec(String[] properties, String targetType) {
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = targetType;
        propSpec.propertyNames = properties;
        return propSpec;
    }

    private QuerySpec buildQuerySpec(Constraint constraint, String[] properties, Set<String> targetTypes) {
        QuerySpec query = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        if (targetTypes != null) {
            for (String targetType : targetTypes) {
                PropertySpec propSpec = this.createPropertySpec(properties, targetType);
                pSpecs.add(propSpec);
            }
        } else {
            PropertySpec propSpec = this.createPropertySpec(properties, null);
            pSpecs.add(propSpec);
        }
        resourceSpec.propertySpecs = pSpecs.toArray(new PropertySpec[0]);
        query.resourceSpec = resourceSpec;
        return query;
    }

    private QuerySpec buildQuerySpec(Object entity, String[] properties) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        String targetType = this._vimObjectReferenceService.getResourceObjectType(entity);
        HashSet<String> targetTypes = new HashSet<String>();
        targetTypes.add(targetType);
        QuerySpec query = this.buildQuerySpec((Constraint)oc, properties, targetTypes);
        return query;
    }

    private QuerySpec buildQuerySpec(Object[] entities, String[] properties) {
        if (entities.length == 1) {
            return this.buildQuerySpec(entities[0], properties);
        }
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = Conjoiner.OR;
        Constraint[] nestedConstraints = new Constraint[entities.length];
        HashSet<String> targetTypes = new HashSet<String>();
        String targetType = null;
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            nestedConstraints[index] = oc;
            targetType = this._vimObjectReferenceService.getResourceObjectType(oc.target);
            targetTypes.add(targetType);
        }
        cc.nestedConstraints = nestedConstraints;
        QuerySpec query = this.buildQuerySpec((Constraint)cc, properties, targetTypes);
        return query;
    }

    private ResultSet getData(DataService dataService, QuerySpec query) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{query};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        ResultSet[] retVal = response.resultSet;
        if (retVal == null || retVal.length == 0 || retVal[0] == null) {
            throw new Exception("Empty result");
        }
        return retVal[0];
    }
}

