/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin.mvc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class Config {
    private String vCenterIp = "";
    private String apiKey = "";
    private String url = "";

    public String getVCenterIp() {
        return this.vCenterIp;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean readFromFile() {
        Config config = new Config();
        try {
            String readStr;
            String os = System.getProperty("os.name");
            String pathname = "/usr/lib/vmware/dbackup.conf";
            if (os.toLowerCase().startsWith("win")) {
                pathname = "C:\\ProgramData\\VMware\\dbackup.conf";
            }
            File filename = new File(pathname);
            filename.setWritable(true);
            if (!filename.exists()) {
                filename.createNewFile();
            }
            InputStreamReader reader = new InputStreamReader(new FileInputStream(filename));
            BufferedReader br = new BufferedReader(reader);
            while ((readStr = br.readLine()) != null) {
                if (readStr.contains("vCenter_ip")) {
                    this.vCenterIp = readStr.split("=")[1].trim();
                }
                if (readStr.contains("dbackup_url")) {
                    this.url = readStr.split("=")[1].trim();
                }
                if (!readStr.contains("api_key")) continue;
                this.apiKey = readStr.split("=")[1].trim();
            }
            br.close();
            return !this.vCenterIp.isEmpty() && !this.url.isEmpty() && !this.apiKey.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

