/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin.services;

import com.scutech.dbackup.vsphere.plugin.mvc.Config;
import com.scutech.dbackup.vsphere.plugin.services.HTTPService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HTTPServiceImpl
implements HTTPService {
    private Config config = new Config();

    @Override
    public String sendGet(String url, String param) {
        url = this.config.getUrl() + url + "?" + param;
        String result = "";
        try {
            URL realUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/5.0 Chrome/89.0.4389.82 Safari/537.36 vsphere-plugin/1.0");
            connection.setRequestProperty("X-Api-Key", this.config.getApiKey());
            connection.connect();
            if (connection.getResponseCode() == 200) {
                Map<String, List<String>> headers = connection.getHeaderFields();
                System.out.println(headers);
                BufferedReader reader = null;
                StringBuffer resultBuffer = new StringBuffer();
                String tempLine = null;
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((tempLine = reader.readLine()) != null) {
                    resultBuffer.append(tempLine);
                }
                reader.close();
                result = resultBuffer.toString();
            }
        }
        catch (Exception e) {
            System.out.println("sendGet error" + e);
            e.printStackTrace();
        }
        return result.replaceAll("\"", "");
    }

    @Override
    public String sendPost(String url, String param) {
        url = this.config.getUrl() + url;
        String result = "";
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/5.0 Chrome/89.0.4389.82 Safari/537.36 vsphere-plugin/1.0");
            conn.setRequestProperty("X-Api-Key", this.config.getApiKey());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(conn.getOutputStream()));
            pw.print(param);
            pw.flush();
            pw.close();
            conn.connect();
            if (conn.getResponseCode() == 200) {
                Map<String, List<String>> headers = conn.getHeaderFields();
                System.out.println(headers);
                BufferedReader reader = null;
                StringBuffer resultBuffer = new StringBuffer();
                String tempLine = null;
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((tempLine = reader.readLine()) != null) {
                    resultBuffer.append(tempLine);
                }
                reader.close();
                result = resultBuffer.toString();
            } else {
                result = conn.getResponseCode() + "";
            }
        }
        catch (Exception e) {
            result = e.toString();
            e.printStackTrace();
        }
        return result.replaceAll("\"", "");
    }

    @Override
    public boolean isReady() {
        try {
            if (!this.config.readFromFile()) {
                return false;
            }
            String param = "ip=" + this.config.getVCenterIp();
            String check = this.sendGet("/ds/dbackup/vcenter/register/status", param);
            if (check.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getVMStatus(String uuid) {
        String param = "uuids=" + uuid;
        String pathUrl = "/ds/dbackup/vcenter/vm/task";
        return this.sendPost(pathUrl, param);
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }
}

