/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin.mvc;

import com.scutech.dbackup.vsphere.plugin.mvc.QueryUtil;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/data"}, method={RequestMethod.GET})
public class DataAccessController {
    private static final String OBJECT_ID = "id";
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public DataAccessController(DataService dataService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
        QueryUtil.setObjectReferenceService(objectReferenceService);
    }

    public DataAccessController() {
        this._dataService = null;
        this._objectReferenceService = null;
    }

    @RequestMapping(value={"/properties/{objectId}"})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String encodedObjectId, @RequestParam(value="properties", required=true) String properties) throws Exception {
        Object ref = this.getDecodedReference(encodedObjectId);
        String objectId = this._objectReferenceService.getUid(ref);
        String[] props = properties.split(",");
        PropertyValue[] pvs = QueryUtil.getProperties(this._dataService, ref, props);
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put(OBJECT_ID, objectId);
        for (PropertyValue pv : pvs) {
            propsMap.put(pv.propertyName, pv.value);
        }
        return propsMap;
    }

    @RequestMapping(value={"/propertiesByRelation/{objectId}"})
    @ResponseBody
    public PropertyValue[] getPropertiesForRelatedObject(@PathVariable(value="objectId") String encodedObjectId, @RequestParam(value="relation", required=true) String relation, @RequestParam(value="targetType", required=true) String targetType, @RequestParam(value="properties", required=true) String properties) throws Exception {
        Object ref = this.getDecodedReference(encodedObjectId);
        String[] props = properties.split(",");
        PropertyValue[] result = QueryUtil.getPropertiesForRelatedObjects(this._dataService, ref, relation, targetType, props);
        return result;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("message", ex.getMessage());
        if (ex.getCause() != null) {
            errorMap.put("cause", ex.getCause().getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        errorMap.put("stackTrace", sw.toString());
        return errorMap;
    }

    private Object getDecodedReference(String encodedObjectId) throws Exception {
        Object ref = this._objectReferenceService.getReference(encodedObjectId, true);
        if (ref == null) {
            throw new Exception("Object not found with id: " + encodedObjectId);
        }
        return ref;
    }
}

