@echo off
:begin

set conf_file=C:\ProgramData\VMware\dbackup.conf
set skip_config=n

if exist %conf_file% (
    echo Current config:
    type %conf_file%
    set /p skip_config="Are you want to skip config?[Y/n]"
)

if /i not "%skip_config%"=="n" (
  goto install
)

echo Sample of virtual center IP address: 192.168.2.1
echo Sample of backup server url: http://192.168.20.1
echo Sample of backup server api key: ca2040e7d61000014d0fa7528600100
set /p vCenter_ip="Please input virtual center IP address: "
set /p dbackup_url="Please input backup server url: "
set /p api_key="Please input backup server api key: "

if not defined vCenter_ip (
    echo "No virtual center IP address was entered!"
    goto begin
)
if not defined dbackup_url (
    echo "No backup server url was entered!"
    goto begin
)

if not defined api_key (
    echo "No backup server api key was entered!"
    goto begin
)

echo The virtual center IP address you have entered is: %vCenter_ip%
echo The url you have entered is: %dbackup_url%
echo The api key you have entered is: %api_key%
set /p var="Please confirm your input[Y/n]"

if /i "%var%"=="n" goto begin

(
    echo vCenter_ip  = %vCenter_ip%
    echo dbackup_url = %dbackup_url%
    echo api_key = %api_key%
)>%conf_file%

echo The config file dist: %conf_file%

:install

set vm_data_dir=%VMWARE_DATA_DIR%
set vm_root=%vm_data_dir:\vCenterServer\data=%
set vs_ui_dir=\vCenterServer\runtime\vsphere-ui\plugin-packages\dbackup-plugin
set vs_ui_path=%vm_root%%vs_ui_dir%
set vs_client_dir=\vCenterServer\runtime\vsphere-client\plugin-packages\dbackup-plugin
set vs_client_path=%vm_root%%vs_client_dir%

rmdir /s/q %vs_ui_path%
rmdir /s/q %vs_client_path%

xcopy /s/i/y dbackup-plugin %vs_ui_path%
xcopy /s/i/y dbackup-plugin %vs_client_path%

:end
pause
exit
