/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin.mvc;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionResult {
    static final String ACTIONUID = "actionUid";
    static final String ERROR_MESSAGE = "errorMessage";
    static final String RESULT = "result";
    static final String OPERATION_TYPE = "operationType";
    static final String OP_ADD = "add";
    static final String OP_CHANGE = "change";
    static final String OP_DELETE = "delete";
    static final String OP_RELATIONSHIP_CHANGE = "relationship_change";
    private static final Log _logger = LogFactory.getLog(ActionResult.class);
    private Map<String, Object> _resultMap = new HashMap<String, Object>();
    private String _resourceBundle;

    public ActionResult(String actionUid, String resourceBundle) {
        this._resultMap.put(ACTIONUID, actionUid);
        this._resourceBundle = resourceBundle;
    }

    public Map<String, Object> getJsonMap() {
        if (this._resultMap.get(RESULT) == null && this._resultMap.get(ERROR_MESSAGE) == null) {
            _logger.error((Object)("Missing result or error message in ActionResult for " + this._resultMap.get(ACTIONUID)));
        }
        return this._resultMap;
    }

    public void setResult(Object result, String errMsgKey) {
        this._resultMap.put(RESULT, result);
        if (errMsgKey != null && (result == null || result instanceof Boolean && !((Boolean)result).booleanValue())) {
            this.setErrorMessage(errMsgKey);
        }
    }

    public void setObjectAddedResult(URI result, String uriType, String errMsgKey) {
        this._resultMap.put(RESULT, result);
        this._resultMap.put(OPERATION_TYPE, OP_ADD);
        this._resultMap.put("uriType", uriType);
        if (result == null && errMsgKey != null) {
            this.setErrorMessage(errMsgKey);
        }
    }

    public void setObjectDeletedResult(boolean result, String errMsgKey) {
        this._resultMap.put(RESULT, result);
        this._resultMap.put(OPERATION_TYPE, OP_DELETE);
        if (!result && errMsgKey != null) {
            this.setErrorMessage(errMsgKey);
        }
    }

    public void setObjectChangedResult(boolean result, String errMsgKey) {
        this._resultMap.put(RESULT, result);
        this._resultMap.put(OPERATION_TYPE, OP_CHANGE);
        if (!result && errMsgKey != null) {
            this.setErrorMessage(errMsgKey);
        }
    }

    public void setErrorLocalizedMessage(String msg) {
        this._resultMap.put(ERROR_MESSAGE, msg);
    }

    public void setErrorMessage(String key) {
        this.setErrorMessage(key, null);
    }

    public void setErrorMessage(String key, String[] params) {
        this._resultMap.put(ERROR_MESSAGE, new ActionMessage(this._resourceBundle, key, params));
    }

    class ActionMessage {
        public String bundleName;
        public String key;
        public String[] params;

        ActionMessage() {
        }

        ActionMessage(String bundleName, String key, String[] params) {
            this.bundleName = bundleName;
            this.key = key;
            this.params = params;
        }
    }
}

