/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin.mvc;

import com.scutech.dbackup.vsphere.plugin.services.HTTPServiceImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/services"})
public class ServicesController {
    private static final Log _logger = LogFactory.getLog(ServicesController.class);
    private final HTTPServiceImpl _httpService = new HTTPServiceImpl();

    @RequestMapping(value={"/echo"}, method={RequestMethod.POST})
    @ResponseBody
    public String echo() throws Exception {
        if (this._httpService.isReady()) {
            return this._httpService.getUrl();
        }
        return "";
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.POST})
    @ResponseBody
    public String echo(@RequestParam(value="uuid", required=true) String uuid) throws Exception {
        return this._httpService.getVMStatus(uuid);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("message", ex.getMessage());
        if (ex.getCause() != null) {
            errorMap.put("cause", ex.getCause().getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        errorMap.put("stackTrace", sw.toString());
        return errorMap;
    }
}

