/*
 * Decompiled with CFR 0.152.
 */
package com.scutech.dbackup.vsphere.plugin.mvc;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class QueryUtil {
    private static ObjectReferenceService _objectReferenceService;

    public static void setObjectReferenceService(ObjectReferenceService objectReferenceService) {
        _objectReferenceService = objectReferenceService;
    }

    public static PropertyValue[] getProperties(DataService dataService, Object obj, String[] properties) throws Exception {
        return QueryUtil.getProperties(dataService, new Object[]{obj}, properties);
    }

    public static PropertyValue[] getProperties(DataService dataService, Object[] objs, String[] properties) throws Exception {
        ResultItem[] items;
        if (objs == null || objs.length == 0 || properties == null || properties.length == 0) {
            throw new Exception("Invalid parameters for getProperties");
        }
        Object obj = objs[0];
        QuerySpec query = QueryUtil.buildQuerySpec(objs, properties);
        query.name = _objectReferenceService.getUid(obj) + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return QueryUtil.toArray(result, PropertyValue.class);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> elementType) {
        Object[] result = null;
        if (collection == null) {
            result = (Object[])Array.newInstance(elementType, 0);
            return result;
        }
        Object[] copy = (Object[])Array.newInstance(elementType, collection.size());
        result = collection.toArray(copy);
        return result;
    }

    public static PropertyValue[] getPropertyForRelatedObjects(DataService dataService, Object object, String relationship, String targetType, String property) throws Exception {
        return QueryUtil.getPropertiesForRelatedObjects(dataService, object, relationship, targetType, new String[]{property});
    }

    public static PropertyValue[] getPropertiesForRelatedObjects(DataService dataService, Object obj, String relationship, String targetType, String[] properties) throws Exception {
        if (obj == null || properties == null || properties.length == 0) {
            throw new Exception("invalid parameters in getPropertiesForRelatedObjects");
        }
        if (relationship == null || relationship.length() == 0) {
            return QueryUtil.getProperties(dataService, obj, properties);
        }
        ObjectIdentityConstraint objectConstraint = QueryUtil.createObjectIdentityConstraint(obj);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint(relationship, (Constraint)objectConstraint, true, targetType);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)relationalConstraint, properties);
        query.name = _objectReferenceService.getUid(obj) + "." + relationship + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                if (item == null || item.properties == null) continue;
                for (PropertyValue propValue : item.properties) {
                    if (propValue == null) continue;
                    result.add(propValue);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return QueryUtil.toArray(result, PropertyValue.class);
    }

    public static ResultSet getData(DataService dataService, QuerySpec query) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{query};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        ResultSet[] retVal = response.resultSet;
        if (retVal == null || retVal.length == 0 || retVal[0] == null) {
            throw new Exception("Empty result");
        }
        return retVal[0];
    }

    public static QuerySpec buildQuerySpec(Object entity, String[] properties) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        String targetType = _objectReferenceService.getResourceObjectType(entity);
        HashSet<String> targetTypes = new HashSet<String>();
        targetTypes.add(targetType);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)oc, properties, targetTypes);
        return query;
    }

    public static QuerySpec buildQuerySpec(Object[] entities, String[] properties) {
        if (entities.length == 1) {
            return QueryUtil.buildQuerySpec(entities[0], properties);
        }
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = Conjoiner.OR;
        Constraint[] nestedConstraints = new Constraint[entities.length];
        HashSet<String> targetTypes = new HashSet<String>();
        String targetType = null;
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            nestedConstraints[index] = oc;
            targetType = _objectReferenceService.getResourceObjectType(oc.target);
            targetTypes.add(targetType);
        }
        cc.nestedConstraints = nestedConstraints;
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)cc, properties, targetTypes);
        return query;
    }

    public static QuerySpec buildQuerySpec(Constraint constraint, String[] properties) {
        QuerySpec query = QueryUtil.buildQuerySpec(constraint, properties, null);
        return query;
    }

    public static QuerySpec buildQuerySpec(Constraint constraint, String[] properties, Set<String> targetTypes) {
        QuerySpec query = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        if (targetTypes != null) {
            for (String targetType : targetTypes) {
                PropertySpec propSpec = QueryUtil.createPropertySpec(properties, targetType);
                pSpecs.add(propSpec);
            }
        } else {
            PropertySpec propSpec = QueryUtil.createPropertySpec(properties, null);
            pSpecs.add(propSpec);
        }
        resourceSpec.propertySpecs = pSpecs.toArray(new PropertySpec[0]);
        query.resourceSpec = resourceSpec;
        return query;
    }

    public static RelationalConstraint createRelationalConstraint(String relationship, Constraint constraintOnRelatedObject, Boolean hasInverseRelation, String targetType) {
        RelationalConstraint rc = new RelationalConstraint();
        rc.relation = relationship;
        rc.hasInverseRelation = hasInverseRelation;
        rc.constraintOnRelatedObject = constraintOnRelatedObject;
        rc.targetType = targetType;
        return rc;
    }

    public static ObjectIdentityConstraint createObjectIdentityConstraint(Object entity) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        oc.targetType = _objectReferenceService.getResourceObjectType(entity);
        return oc;
    }

    private static PropertySpec createPropertySpec(String[] properties, String targetType) {
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = targetType;
        propSpec.propertyNames = properties;
        return propSpec;
    }
}

